// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Astro.Models
{
    /// <summary> Properties specific to Single Sign On Resource. </summary>
    public partial class AstroSingleSignOnProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AstroSingleSignOnProperties"/>. </summary>
        public AstroSingleSignOnProperties()
        {
            AadDomains = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AstroSingleSignOnProperties"/>. </summary>
        /// <param name="singleSignOnState"> State of the Single Sign On for the organization. </param>
        /// <param name="enterpriseAppId"> AAD enterprise application Id used to setup SSO. </param>
        /// <param name="singleSignOnUri"> URL for SSO to be used by the partner to redirect the user to their system. </param>
        /// <param name="aadDomains"> List of AAD domains fetched from Microsoft Graph for user. </param>
        /// <param name="provisioningState"> Provisioning State of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AstroSingleSignOnProperties(AstroSingleSignOnState? singleSignOnState, string enterpriseAppId, Uri singleSignOnUri, IList<string> aadDomains, AstroResourceProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SingleSignOnState = singleSignOnState;
            EnterpriseAppId = enterpriseAppId;
            SingleSignOnUri = singleSignOnUri;
            AadDomains = aadDomains;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> State of the Single Sign On for the organization. </summary>
        public AstroSingleSignOnState? SingleSignOnState { get; set; }
        /// <summary> AAD enterprise application Id used to setup SSO. </summary>
        public string EnterpriseAppId { get; set; }
        /// <summary> URL for SSO to be used by the partner to redirect the user to their system. </summary>
        public Uri SingleSignOnUri { get; set; }
        /// <summary> List of AAD domains fetched from Microsoft Graph for user. </summary>
        public IList<string> AadDomains { get; }
        /// <summary> Provisioning State of the resource. </summary>
        public AstroResourceProvisioningState? ProvisioningState { get; }
    }
}
