// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Astro.Models
{
    /// <summary> Properties specific to Partner's organization. </summary>
    public partial class AstroPartnerOrganizationUpdateProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AstroPartnerOrganizationUpdateProperties"/>. </summary>
        public AstroPartnerOrganizationUpdateProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AstroPartnerOrganizationUpdateProperties"/>. </summary>
        /// <param name="organizationId"> Organization Id in partner's system. </param>
        /// <param name="workspaceId"> Workspace Id in partner's system. </param>
        /// <param name="organizationName"> Organization name in partner's system. </param>
        /// <param name="workspaceName"> Workspace name in partner's system. </param>
        /// <param name="singleSignOnProperties"> Single Sign On properties for the organization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AstroPartnerOrganizationUpdateProperties(string organizationId, string workspaceId, string organizationName, string workspaceName, AstroSingleSignOnProperties singleSignOnProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OrganizationId = organizationId;
            WorkspaceId = workspaceId;
            OrganizationName = organizationName;
            WorkspaceName = workspaceName;
            SingleSignOnProperties = singleSignOnProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Organization Id in partner's system. </summary>
        public string OrganizationId { get; set; }
        /// <summary> Workspace Id in partner's system. </summary>
        public string WorkspaceId { get; set; }
        /// <summary> Organization name in partner's system. </summary>
        public string OrganizationName { get; set; }
        /// <summary> Workspace name in partner's system. </summary>
        public string WorkspaceName { get; set; }
        /// <summary> Single Sign On properties for the organization. </summary>
        public AstroSingleSignOnProperties SingleSignOnProperties { get; set; }
    }
}
