// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Astro.Models
{
    public partial class AstroOrganizationUpdateProperties : IUtf8JsonSerializable, IJsonModel<AstroOrganizationUpdateProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AstroOrganizationUpdateProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AstroOrganizationUpdateProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AstroOrganizationUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AstroOrganizationUpdateProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(User))
            {
                writer.WritePropertyName("user"u8);
                writer.WriteObjectValue(User, options);
            }
            if (Optional.IsDefined(PartnerOrganizationProperties))
            {
                writer.WritePropertyName("partnerOrganizationProperties"u8);
                writer.WriteObjectValue(PartnerOrganizationProperties, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AstroOrganizationUpdateProperties IJsonModel<AstroOrganizationUpdateProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AstroOrganizationUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AstroOrganizationUpdateProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAstroOrganizationUpdateProperties(document.RootElement, options);
        }

        internal static AstroOrganizationUpdateProperties DeserializeAstroOrganizationUpdateProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AstroUserUpdateDetails user = default;
            AstroPartnerOrganizationUpdateProperties partnerOrganizationProperties = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("user"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    user = AstroUserUpdateDetails.DeserializeAstroUserUpdateDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("partnerOrganizationProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    partnerOrganizationProperties = AstroPartnerOrganizationUpdateProperties.DeserializeAstroPartnerOrganizationUpdateProperties(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AstroOrganizationUpdateProperties(user, partnerOrganizationProperties, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AstroOrganizationUpdateProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AstroOrganizationUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AstroOrganizationUpdateProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AstroOrganizationUpdateProperties IPersistableModel<AstroOrganizationUpdateProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AstroOrganizationUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAstroOrganizationUpdateProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AstroOrganizationUpdateProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AstroOrganizationUpdateProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
