// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Astro.Models
{
    /// <summary> Properties specific to Data Organization resource. </summary>
    public partial class AstroOrganizationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AstroOrganizationProperties"/>. </summary>
        /// <param name="marketplace"> Marketplace details of the resource. </param>
        /// <param name="user"> Details of the user. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="marketplace"/> or <paramref name="user"/> is null. </exception>
        public AstroOrganizationProperties(AstroMarketplaceDetails marketplace, AstroUserDetails user)
        {
            Argument.AssertNotNull(marketplace, nameof(marketplace));
            Argument.AssertNotNull(user, nameof(user));

            Marketplace = marketplace;
            User = user;
        }

        /// <summary> Initializes a new instance of <see cref="AstroOrganizationProperties"/>. </summary>
        /// <param name="marketplace"> Marketplace details of the resource. </param>
        /// <param name="user"> Details of the user. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="partnerOrganizationProperties"> Organization properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AstroOrganizationProperties(AstroMarketplaceDetails marketplace, AstroUserDetails user, AstroResourceProvisioningState? provisioningState, AstroPartnerOrganizationProperties partnerOrganizationProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Marketplace = marketplace;
            User = user;
            ProvisioningState = provisioningState;
            PartnerOrganizationProperties = partnerOrganizationProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AstroOrganizationProperties"/> for deserialization. </summary>
        internal AstroOrganizationProperties()
        {
        }

        /// <summary> Marketplace details of the resource. </summary>
        public AstroMarketplaceDetails Marketplace { get; set; }
        /// <summary> Details of the user. </summary>
        public AstroUserDetails User { get; set; }
        /// <summary> Provisioning state of the resource. </summary>
        public AstroResourceProvisioningState? ProvisioningState { get; }
        /// <summary> Organization properties. </summary>
        public AstroPartnerOrganizationProperties PartnerOrganizationProperties { get; set; }
    }
}
