// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Astro.Models
{
    /// <summary> Offer details for the marketplace that is selected by the user. </summary>
    public partial class AstroOfferDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AstroOfferDetails"/>. </summary>
        /// <param name="publisherId"> Publisher Id for the marketplace offer. </param>
        /// <param name="offerId"> Offer Id for the marketplace offer. </param>
        /// <param name="planId"> Plan Id for the marketplace offer. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="publisherId"/>, <paramref name="offerId"/> or <paramref name="planId"/> is null. </exception>
        public AstroOfferDetails(string publisherId, string offerId, string planId)
        {
            Argument.AssertNotNull(publisherId, nameof(publisherId));
            Argument.AssertNotNull(offerId, nameof(offerId));
            Argument.AssertNotNull(planId, nameof(planId));

            PublisherId = publisherId;
            OfferId = offerId;
            PlanId = planId;
        }

        /// <summary> Initializes a new instance of <see cref="AstroOfferDetails"/>. </summary>
        /// <param name="publisherId"> Publisher Id for the marketplace offer. </param>
        /// <param name="offerId"> Offer Id for the marketplace offer. </param>
        /// <param name="planId"> Plan Id for the marketplace offer. </param>
        /// <param name="planName"> Plan Name for the marketplace offer. </param>
        /// <param name="termUnit"> Plan Display Name for the marketplace offer. </param>
        /// <param name="termId"> Plan Display Name for the marketplace offer. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AstroOfferDetails(string publisherId, string offerId, string planId, string planName, string termUnit, string termId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublisherId = publisherId;
            OfferId = offerId;
            PlanId = planId;
            PlanName = planName;
            TermUnit = termUnit;
            TermId = termId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AstroOfferDetails"/> for deserialization. </summary>
        internal AstroOfferDetails()
        {
        }

        /// <summary> Publisher Id for the marketplace offer. </summary>
        public string PublisherId { get; set; }
        /// <summary> Offer Id for the marketplace offer. </summary>
        public string OfferId { get; set; }
        /// <summary> Plan Id for the marketplace offer. </summary>
        public string PlanId { get; set; }
        /// <summary> Plan Name for the marketplace offer. </summary>
        public string PlanName { get; set; }
        /// <summary> Plan Display Name for the marketplace offer. </summary>
        public string TermUnit { get; set; }
        /// <summary> Plan Display Name for the marketplace offer. </summary>
        public string TermId { get; set; }
    }
}
