// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Astro
{
    internal class AstroOrganizationOperationSource : IOperationSource<AstroOrganizationResource>
    {
        private readonly ArmClient _client;

        internal AstroOrganizationOperationSource(ArmClient client)
        {
            _client = client;
        }

        AstroOrganizationResource IOperationSource<AstroOrganizationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AstroOrganizationData.DeserializeAstroOrganizationData(document.RootElement);
            return new AstroOrganizationResource(_client, data);
        }

        async ValueTask<AstroOrganizationResource> IOperationSource<AstroOrganizationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AstroOrganizationData.DeserializeAstroOrganizationData(document.RootElement);
            return new AstroOrganizationResource(_client, data);
        }
    }
}
