// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Astro.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableAstroResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAstroResourceGroupResource"/> class for mocking. </summary>
        protected MockableAstroResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAstroResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAstroResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of AstroOrganizationResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of AstroOrganizationResources and their operations over a AstroOrganizationResource. </returns>
        public virtual AstroOrganizationCollection GetAstroOrganizations()
        {
            return GetCachedClient(client => new AstroOrganizationCollection(client, Id));
        }

        /// <summary>
        /// Get a OrganizationResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Astronomer.Astro/organizations/{organizationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Organizations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AstroOrganizationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AstroOrganizationResource>> GetAstroOrganizationAsync(string organizationName, CancellationToken cancellationToken = default)
        {
            return await GetAstroOrganizations().GetAsync(organizationName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a OrganizationResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Astronomer.Astro/organizations/{organizationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Organizations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AstroOrganizationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AstroOrganizationResource> GetAstroOrganization(string organizationName, CancellationToken cancellationToken = default)
        {
            return GetAstroOrganizations().Get(organizationName, cancellationToken);
        }
    }
}
