// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Astro.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableAstroArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAstroArmClient"/> class for mocking. </summary>
        protected MockableAstroArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAstroArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAstroArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableAstroArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="AstroOrganizationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AstroOrganizationResource.CreateResourceIdentifier" /> to create an <see cref="AstroOrganizationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AstroOrganizationResource"/> object. </returns>
        public virtual AstroOrganizationResource GetAstroOrganizationResource(ResourceIdentifier id)
        {
            AstroOrganizationResource.ValidateResourceId(id);
            return new AstroOrganizationResource(Client, id);
        }
    }
}
