// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ScVmm.Models;

namespace Azure.ResourceManager.ScVmm
{
    /// <summary>
    /// A Class representing a ScVmmVirtualMachineInstance along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="ScVmmVirtualMachineInstanceResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetScVmmVirtualMachineInstanceResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetScVmmVirtualMachineInstance method.
    /// </summary>
    public partial class ScVmmVirtualMachineInstanceResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="ScVmmVirtualMachineInstanceResource"/> instance. </summary>
        /// <param name="resourceUri"> The resourceUri. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceUri)
        {
            var resourceId = $"{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics;
        private readonly VirtualMachineInstancesRestOperations _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient;
        private readonly ScVmmVirtualMachineInstanceData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.ScVmm/virtualMachineInstances";

        /// <summary> Initializes a new instance of the <see cref="ScVmmVirtualMachineInstanceResource"/> class for mocking. </summary>
        protected ScVmmVirtualMachineInstanceResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ScVmmVirtualMachineInstanceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal ScVmmVirtualMachineInstanceResource(ArmClient client, ScVmmVirtualMachineInstanceData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="ScVmmVirtualMachineInstanceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal ScVmmVirtualMachineInstanceResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ScVmm", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string scVmmVirtualMachineInstanceVirtualMachineInstancesApiVersion);
            _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient = new VirtualMachineInstancesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, scVmmVirtualMachineInstanceVirtualMachineInstancesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual ScVmmVirtualMachineInstanceData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets an object representing a ScVmmHybridIdentityMetadataResource along with the instance operations that can be performed on it in the ScVmmVirtualMachineInstance. </summary>
        /// <returns> Returns a <see cref="ScVmmHybridIdentityMetadataResource"/> object. </returns>
        public virtual ScVmmHybridIdentityMetadataResource GetScVmmHybridIdentityMetadata()
        {
            return new ScVmmHybridIdentityMetadataResource(Client, Id.AppendChildResource("hybridIdentityMetadata", "default"));
        }

        /// <summary> Gets an object representing a ScVmmGuestAgentResource along with the instance operations that can be performed on it in the ScVmmVirtualMachineInstance. </summary>
        /// <returns> Returns a <see cref="ScVmmGuestAgentResource"/> object. </returns>
        public virtual ScVmmGuestAgentResource GetScVmmGuestAgent()
        {
            return new ScVmmGuestAgentResource(Client, Id.AppendChildResource("guestAgents", "default"));
        }

        /// <summary>
        /// Retrieves information about a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ScVmmVirtualMachineInstanceResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Get");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.GetAsync(Id.Parent, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ScVmmVirtualMachineInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieves information about a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ScVmmVirtualMachineInstanceResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Get");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.Get(Id.Parent, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ScVmmVirtualMachineInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to delete a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="force"> Whether force delete was specified. </param>
        /// <param name="deleteFromHost"> Whether to disable the VM from azure and also delete it from VMM. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, ScVmmForceDeletion? force = null, DeleteFromHost? deleteFromHost = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Delete");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.DeleteAsync(Id.Parent, force, deleteFromHost, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateDeleteRequest(Id.Parent, force, deleteFromHost).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to delete a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="force"> Whether force delete was specified. </param>
        /// <param name="deleteFromHost"> Whether to disable the VM from azure and also delete it from VMM. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, ScVmmForceDeletion? force = null, DeleteFromHost? deleteFromHost = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Delete");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.Delete(Id.Parent, force, deleteFromHost, cancellationToken);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateDeleteRequest(Id.Parent, force, deleteFromHost).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to update a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="patch"> Resource properties to update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual async Task<ArmOperation<ScVmmVirtualMachineInstanceResource>> UpdateAsync(WaitUntil waitUntil, ScVmmVirtualMachineInstancePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Update");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.UpdateAsync(Id.Parent, patch, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation<ScVmmVirtualMachineInstanceResource>(new ScVmmVirtualMachineInstanceOperationSource(Client), _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateUpdateRequest(Id.Parent, patch).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to update a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="patch"> Resource properties to update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual ArmOperation<ScVmmVirtualMachineInstanceResource> Update(WaitUntil waitUntil, ScVmmVirtualMachineInstancePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Update");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.Update(Id.Parent, patch, cancellationToken);
                var operation = new ScVmmArmOperation<ScVmmVirtualMachineInstanceResource>(new ScVmmVirtualMachineInstanceOperationSource(Client), _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateUpdateRequest(Id.Parent, patch).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to create or update a virtual machine instance. Please note some properties can be set only during virtual machine instance creation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ScVmmVirtualMachineInstanceResource>> CreateOrUpdateAsync(WaitUntil waitUntil, ScVmmVirtualMachineInstanceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateOrUpdateAsync(Id.Parent, data, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation<ScVmmVirtualMachineInstanceResource>(new ScVmmVirtualMachineInstanceOperationSource(Client), _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateCreateOrUpdateRequest(Id.Parent, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to create or update a virtual machine instance. Please note some properties can be set only during virtual machine instance creation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ScVmmVirtualMachineInstanceResource> CreateOrUpdate(WaitUntil waitUntil, ScVmmVirtualMachineInstanceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateOrUpdate(Id.Parent, data, cancellationToken);
                var operation = new ScVmmArmOperation<ScVmmVirtualMachineInstanceResource>(new ScVmmVirtualMachineInstanceOperationSource(Client), _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateCreateOrUpdateRequest(Id.Parent, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to power off (stop) a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/stop</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Stop</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine stop action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> StopAsync(WaitUntil waitUntil, StopVirtualMachineContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Stop");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.StopAsync(Id.Parent, content, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateStopRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to power off (stop) a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/stop</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Stop</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine stop action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Stop(WaitUntil waitUntil, StopVirtualMachineContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Stop");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.Stop(Id.Parent, content, cancellationToken);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateStopRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to start a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/start</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Start</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> StartAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Start");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.StartAsync(Id.Parent, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateStartRequest(Id.Parent).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to start a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/start</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Start</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Start(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Start");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.Start(Id.Parent, cancellationToken);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateStartRequest(Id.Parent).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to restart a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/restart</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Restart</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> RestartAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Restart");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.RestartAsync(Id.Parent, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateRestartRequest(Id.Parent).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to restart a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/restart</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Restart</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Restart(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.Restart");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.Restart(Id.Parent, cancellationToken);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateRestartRequest(Id.Parent).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a checkpoint in virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/createCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_CreateCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine create checkpoint action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> CreateCheckpointAsync(WaitUntil waitUntil, VirtualMachineCreateCheckpointContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.CreateCheckpoint");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateCheckpointAsync(Id.Parent, content, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateCreateCheckpointRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a checkpoint in virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/createCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_CreateCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine create checkpoint action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation CreateCheckpoint(WaitUntil waitUntil, VirtualMachineCreateCheckpointContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.CreateCheckpoint");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateCheckpoint(Id.Parent, content, cancellationToken);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateCreateCheckpointRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes a checkpoint in virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/deleteCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_DeleteCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine delete checkpoint action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteCheckpointAsync(WaitUntil waitUntil, VirtualMachineDeleteCheckpointContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.DeleteCheckpoint");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.DeleteCheckpointAsync(Id.Parent, content, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateDeleteCheckpointRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes a checkpoint in virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/deleteCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_DeleteCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine delete checkpoint action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation DeleteCheckpoint(WaitUntil waitUntil, VirtualMachineDeleteCheckpointContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.DeleteCheckpoint");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.DeleteCheckpoint(Id.Parent, content, cancellationToken);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateDeleteCheckpointRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Restores to a checkpoint in virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/restoreCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_RestoreCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine restore checkpoint action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> RestoreCheckpointAsync(WaitUntil waitUntil, VirtualMachineRestoreCheckpointContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.RestoreCheckpoint");
            scope.Start();
            try
            {
                var response = await _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.RestoreCheckpointAsync(Id.Parent, content, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateRestoreCheckpointRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Restores to a checkpoint in virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/restoreCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_RestoreCheckpoint</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmVirtualMachineInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine restore checkpoint action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation RestoreCheckpoint(WaitUntil waitUntil, VirtualMachineRestoreCheckpointContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("ScVmmVirtualMachineInstanceResource.RestoreCheckpoint");
            scope.Start();
            try
            {
                var response = _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.RestoreCheckpoint(Id.Parent, content, cancellationToken);
                var operation = new ScVmmArmOperation(_scVmmVirtualMachineInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _scVmmVirtualMachineInstanceVirtualMachineInstancesRestClient.CreateRestoreCheckpointRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
