// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;
using Azure.ResourceManager.ScVmm.Models;

namespace Azure.ResourceManager.ScVmm
{
    /// <summary>
    /// A class representing the ScVmmServer data model.
    /// The VmmServers resource definition.
    /// </summary>
    public partial class ScVmmServerData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScVmmServerData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location. </param>
        /// <param name="fqdn"> Fqdn is the hostname/ip of the vmmServer. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedLocation"/> or <paramref name="fqdn"/> is null. </exception>
        public ScVmmServerData(AzureLocation location, ExtendedLocation extendedLocation, string fqdn) : base(location)
        {
            Argument.AssertNotNull(extendedLocation, nameof(extendedLocation));
            Argument.AssertNotNull(fqdn, nameof(fqdn));

            ExtendedLocation = extendedLocation;
            Fqdn = fqdn;
        }

        /// <summary> Initializes a new instance of <see cref="ScVmmServerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location. </param>
        /// <param name="credentials"> Credentials to connect to VMMServer. </param>
        /// <param name="fqdn"> Fqdn is the hostname/ip of the vmmServer. </param>
        /// <param name="port"> Port is the port on which the vmmServer is listening. </param>
        /// <param name="connectionStatus"> Gets the connection status to the vmmServer. </param>
        /// <param name="errorMessage"> Gets any error message if connection to vmmServer is having any issue. </param>
        /// <param name="uuid"> Unique ID of vmmServer. </param>
        /// <param name="version"> Version is the version of the vmmSever. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScVmmServerData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ExtendedLocation extendedLocation, VmmCredential credentials, string fqdn, int? port, string connectionStatus, string errorMessage, string uuid, string version, ScVmmProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ExtendedLocation = extendedLocation;
            Credentials = credentials;
            Fqdn = fqdn;
            Port = port;
            ConnectionStatus = connectionStatus;
            ErrorMessage = errorMessage;
            Uuid = uuid;
            Version = version;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ScVmmServerData"/> for deserialization. </summary>
        internal ScVmmServerData()
        {
        }

        /// <summary> The extended location. </summary>
        public ExtendedLocation ExtendedLocation { get; set; }
        /// <summary> Credentials to connect to VMMServer. </summary>
        public VmmCredential Credentials { get; set; }
        /// <summary> Fqdn is the hostname/ip of the vmmServer. </summary>
        public string Fqdn { get; set; }
        /// <summary> Port is the port on which the vmmServer is listening. </summary>
        public int? Port { get; set; }
        /// <summary> Gets the connection status to the vmmServer. </summary>
        public string ConnectionStatus { get; }
        /// <summary> Gets any error message if connection to vmmServer is having any issue. </summary>
        public string ErrorMessage { get; }
        /// <summary> Unique ID of vmmServer. </summary>
        public string Uuid { get; }
        /// <summary> Version is the version of the vmmSever. </summary>
        public string Version { get; }
        /// <summary> Provisioning state of the resource. </summary>
        public ScVmmProvisioningState? ProvisioningState { get; }
    }
}
