// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ScVmm
{
    /// <summary>
    /// A class representing a collection of <see cref="ScVmmServerResource"/> and their operations.
    /// Each <see cref="ScVmmServerResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="ScVmmServerCollection"/> instance call the GetScVmmServers method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class ScVmmServerCollection : ArmCollection, IEnumerable<ScVmmServerResource>, IAsyncEnumerable<ScVmmServerResource>
    {
        private readonly ClientDiagnostics _scVmmServerVmmServersClientDiagnostics;
        private readonly VmmServersRestOperations _scVmmServerVmmServersRestClient;

        /// <summary> Initializes a new instance of the <see cref="ScVmmServerCollection"/> class for mocking. </summary>
        protected ScVmmServerCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ScVmmServerCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ScVmmServerCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _scVmmServerVmmServersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ScVmm", ScVmmServerResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ScVmmServerResource.ResourceType, out string scVmmServerVmmServersApiVersion);
            _scVmmServerVmmServersRestClient = new VmmServersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, scVmmServerVmmServersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Onboards the SCVMM fabric as an Azure VmmServer resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="vmmServerName"> Name of the VMMServer. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmmServerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmmServerName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ScVmmServerResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string vmmServerName, ScVmmServerData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmmServerName, nameof(vmmServerName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _scVmmServerVmmServersClientDiagnostics.CreateScope("ScVmmServerCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _scVmmServerVmmServersRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, data, cancellationToken).ConfigureAwait(false);
                var operation = new ScVmmArmOperation<ScVmmServerResource>(new ScVmmServerOperationSource(Client), _scVmmServerVmmServersClientDiagnostics, Pipeline, _scVmmServerVmmServersRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Onboards the SCVMM fabric as an Azure VmmServer resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="vmmServerName"> Name of the VMMServer. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmmServerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmmServerName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ScVmmServerResource> CreateOrUpdate(WaitUntil waitUntil, string vmmServerName, ScVmmServerData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmmServerName, nameof(vmmServerName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _scVmmServerVmmServersClientDiagnostics.CreateScope("ScVmmServerCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _scVmmServerVmmServersRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, data, cancellationToken);
                var operation = new ScVmmArmOperation<ScVmmServerResource>(new ScVmmServerOperationSource(Client), _scVmmServerVmmServersClientDiagnostics, Pipeline, _scVmmServerVmmServersRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements VMMServer GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmmServerName"> Name of the VMMServer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmmServerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmmServerName"/> is null. </exception>
        public virtual async Task<Response<ScVmmServerResource>> GetAsync(string vmmServerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmmServerName, nameof(vmmServerName));

            using var scope = _scVmmServerVmmServersClientDiagnostics.CreateScope("ScVmmServerCollection.Get");
            scope.Start();
            try
            {
                var response = await _scVmmServerVmmServersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ScVmmServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements VMMServer GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmmServerName"> Name of the VMMServer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmmServerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmmServerName"/> is null. </exception>
        public virtual Response<ScVmmServerResource> Get(string vmmServerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmmServerName, nameof(vmmServerName));

            using var scope = _scVmmServerVmmServersClientDiagnostics.CreateScope("ScVmmServerCollection.Get");
            scope.Start();
            try
            {
                var response = _scVmmServerVmmServersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ScVmmServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List of VmmServers in a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ScVmmServerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ScVmmServerResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _scVmmServerVmmServersRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _scVmmServerVmmServersRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ScVmmServerResource(Client, ScVmmServerData.DeserializeScVmmServerData(e)), _scVmmServerVmmServersClientDiagnostics, Pipeline, "ScVmmServerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List of VmmServers in a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ScVmmServerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ScVmmServerResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _scVmmServerVmmServersRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _scVmmServerVmmServersRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ScVmmServerResource(Client, ScVmmServerData.DeserializeScVmmServerData(e)), _scVmmServerVmmServersClientDiagnostics, Pipeline, "ScVmmServerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmmServerName"> Name of the VMMServer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmmServerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmmServerName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string vmmServerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmmServerName, nameof(vmmServerName));

            using var scope = _scVmmServerVmmServersClientDiagnostics.CreateScope("ScVmmServerCollection.Exists");
            scope.Start();
            try
            {
                var response = await _scVmmServerVmmServersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmmServerName"> Name of the VMMServer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmmServerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmmServerName"/> is null. </exception>
        public virtual Response<bool> Exists(string vmmServerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmmServerName, nameof(vmmServerName));

            using var scope = _scVmmServerVmmServersClientDiagnostics.CreateScope("ScVmmServerCollection.Exists");
            scope.Start();
            try
            {
                var response = _scVmmServerVmmServersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmmServerName"> Name of the VMMServer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmmServerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmmServerName"/> is null. </exception>
        public virtual async Task<NullableResponse<ScVmmServerResource>> GetIfExistsAsync(string vmmServerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmmServerName, nameof(vmmServerName));

            using var scope = _scVmmServerVmmServersClientDiagnostics.CreateScope("ScVmmServerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _scVmmServerVmmServersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ScVmmServerResource>(response.GetRawResponse());
                return Response.FromValue(new ScVmmServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmmServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-07</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScVmmServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmmServerName"> Name of the VMMServer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmmServerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmmServerName"/> is null. </exception>
        public virtual NullableResponse<ScVmmServerResource> GetIfExists(string vmmServerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmmServerName, nameof(vmmServerName));

            using var scope = _scVmmServerVmmServersClientDiagnostics.CreateScope("ScVmmServerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _scVmmServerVmmServersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, vmmServerName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ScVmmServerResource>(response.GetRawResponse());
                return Response.FromValue(new ScVmmServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ScVmmServerResource> IEnumerable<ScVmmServerResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ScVmmServerResource> IAsyncEnumerable<ScVmmServerResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
