// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> The Virtual machine template inventory item. </summary>
    public partial class VirtualMachineTemplateInventoryItem : ScVmmInventoryItemProperties
    {
        /// <summary> Initializes a new instance of <see cref="VirtualMachineTemplateInventoryItem"/>. </summary>
        public VirtualMachineTemplateInventoryItem()
        {
            InventoryType = ScVmmInventoryType.VirtualMachineTemplate;
        }

        /// <summary> Initializes a new instance of <see cref="VirtualMachineTemplateInventoryItem"/>. </summary>
        /// <param name="inventoryType"> They inventory type. </param>
        /// <param name="managedResourceId"> Gets the tracked resource id corresponding to the inventory resource. </param>
        /// <param name="uuid"> Gets the UUID (which is assigned by VMM) for the inventory item. </param>
        /// <param name="inventoryItemName"> Gets the Managed Object name in VMM for the inventory item. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="cpuCount"> Gets the desired number of vCPUs for the vm. </param>
        /// <param name="memoryMB"> MemoryMB is the desired size of a virtual machine's memory, in MB. </param>
        /// <param name="osType"> Gets the type of the os. </param>
        /// <param name="osName"> Gets os name. </param>
        internal VirtualMachineTemplateInventoryItem(ScVmmInventoryType inventoryType, string managedResourceId, string uuid, string inventoryItemName, ScVmmProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData, int? cpuCount, int? memoryMB, ScVmmOSType? osType, string osName) : base(inventoryType, managedResourceId, uuid, inventoryItemName, provisioningState, serializedAdditionalRawData)
        {
            CpuCount = cpuCount;
            MemoryMB = memoryMB;
            OSType = osType;
            OSName = osName;
            InventoryType = inventoryType;
        }

        /// <summary> Gets the desired number of vCPUs for the vm. </summary>
        public int? CpuCount { get; }
        /// <summary> MemoryMB is the desired size of a virtual machine's memory, in MB. </summary>
        public int? MemoryMB { get; }
        /// <summary> Gets the type of the os. </summary>
        public ScVmmOSType? OSType { get; }
        /// <summary> Gets os name. </summary>
        public string OSName { get; }
    }
}
