// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm.Models
{
    public partial class ScVmmVirtualMachineInstancePatch : IUtf8JsonSerializable, IJsonModel<ScVmmVirtualMachineInstancePatch>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScVmmVirtualMachineInstancePatch>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScVmmVirtualMachineInstancePatch>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmVirtualMachineInstancePatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmVirtualMachineInstancePatch)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(HardwareProfile))
            {
                writer.WritePropertyName("hardwareProfile"u8);
                writer.WriteObjectValue(HardwareProfile, options);
            }
            if (Optional.IsDefined(StorageProfile))
            {
                writer.WritePropertyName("storageProfile"u8);
                writer.WriteObjectValue(StorageProfile, options);
            }
            if (Optional.IsDefined(NetworkProfile))
            {
                writer.WritePropertyName("networkProfile"u8);
                writer.WriteObjectValue(NetworkProfile, options);
            }
            if (Optional.IsCollectionDefined(AvailabilitySets))
            {
                writer.WritePropertyName("availabilitySets"u8);
                writer.WriteStartArray();
                foreach (var item in AvailabilitySets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(InfrastructureProfile))
            {
                writer.WritePropertyName("infrastructureProfile"u8);
                writer.WriteObjectValue(InfrastructureProfile, options);
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScVmmVirtualMachineInstancePatch IJsonModel<ScVmmVirtualMachineInstancePatch>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmVirtualMachineInstancePatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmVirtualMachineInstancePatch)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScVmmVirtualMachineInstancePatch(document.RootElement, options);
        }

        internal static ScVmmVirtualMachineInstancePatch DeserializeScVmmVirtualMachineInstancePatch(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ScVmmHardwareProfileUpdate hardwareProfile = default;
            ScVmmStorageProfileUpdate storageProfile = default;
            ScVmmNetworkProfileUpdate networkProfile = default;
            IList<ScVmmAvailabilitySetItem> availabilitySets = default;
            ScVmmInfrastructureProfileUpdate infrastructureProfile = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("hardwareProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hardwareProfile = ScVmmHardwareProfileUpdate.DeserializeScVmmHardwareProfileUpdate(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("storageProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            storageProfile = ScVmmStorageProfileUpdate.DeserializeScVmmStorageProfileUpdate(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("networkProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            networkProfile = ScVmmNetworkProfileUpdate.DeserializeScVmmNetworkProfileUpdate(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("availabilitySets"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ScVmmAvailabilitySetItem> array = new List<ScVmmAvailabilitySetItem>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ScVmmAvailabilitySetItem.DeserializeScVmmAvailabilitySetItem(item, options));
                            }
                            availabilitySets = array;
                            continue;
                        }
                        if (property0.NameEquals("infrastructureProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            infrastructureProfile = ScVmmInfrastructureProfileUpdate.DeserializeScVmmInfrastructureProfileUpdate(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScVmmVirtualMachineInstancePatch(
                hardwareProfile,
                storageProfile,
                networkProfile,
                availabilitySets ?? new ChangeTrackingList<ScVmmAvailabilitySetItem>(),
                infrastructureProfile,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScVmmVirtualMachineInstancePatch>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmVirtualMachineInstancePatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScVmmVirtualMachineInstancePatch)} does not support writing '{options.Format}' format.");
            }
        }

        ScVmmVirtualMachineInstancePatch IPersistableModel<ScVmmVirtualMachineInstancePatch>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmVirtualMachineInstancePatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScVmmVirtualMachineInstancePatch(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScVmmVirtualMachineInstancePatch)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScVmmVirtualMachineInstancePatch>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
