// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> Virtual disk model. </summary>
    public partial class ScVmmVirtualDisk
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScVmmVirtualDisk"/>. </summary>
        public ScVmmVirtualDisk()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ScVmmVirtualDisk"/>. </summary>
        /// <param name="name"> Gets or sets the name of the disk. </param>
        /// <param name="displayName"> Gets the display name of the virtual disk as shown in the vmmServer. This is the fallback label for a disk when the name is not set. </param>
        /// <param name="diskId"> Gets or sets the disk id. </param>
        /// <param name="diskSizeGB"> Gets or sets the disk total size. </param>
        /// <param name="maxDiskSizeGB"> Gets the max disk size. </param>
        /// <param name="bus"> Gets or sets the disk bus. </param>
        /// <param name="lun"> Gets or sets the disk lun. </param>
        /// <param name="busType"> Gets or sets the disk bus type. </param>
        /// <param name="vhdType"> Gets or sets the disk vhd type. </param>
        /// <param name="volumeType"> Gets the disk volume type. </param>
        /// <param name="vhdFormatType"> Gets the disk vhd format type. </param>
        /// <param name="templateDiskId"> Gets or sets the disk id in the template. </param>
        /// <param name="storageQosPolicy"> The QoS policy for the disk. </param>
        /// <param name="createDiffDisk"> Gets or sets a value indicating diff disk. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScVmmVirtualDisk(string name, string displayName, string diskId, int? diskSizeGB, int? maxDiskSizeGB, int? bus, int? lun, string busType, string vhdType, string volumeType, string vhdFormatType, string templateDiskId, ScVmmStorageQosPolicyDetails storageQosPolicy, CreateDiffDisk? createDiffDisk, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DisplayName = displayName;
            DiskId = diskId;
            DiskSizeGB = diskSizeGB;
            MaxDiskSizeGB = maxDiskSizeGB;
            Bus = bus;
            Lun = lun;
            BusType = busType;
            VhdType = vhdType;
            VolumeType = volumeType;
            VhdFormatType = vhdFormatType;
            TemplateDiskId = templateDiskId;
            StorageQosPolicy = storageQosPolicy;
            CreateDiffDisk = createDiffDisk;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the name of the disk. </summary>
        public string Name { get; set; }
        /// <summary> Gets the display name of the virtual disk as shown in the vmmServer. This is the fallback label for a disk when the name is not set. </summary>
        public string DisplayName { get; }
        /// <summary> Gets or sets the disk id. </summary>
        public string DiskId { get; set; }
        /// <summary> Gets or sets the disk total size. </summary>
        public int? DiskSizeGB { get; set; }
        /// <summary> Gets the max disk size. </summary>
        public int? MaxDiskSizeGB { get; }
        /// <summary> Gets or sets the disk bus. </summary>
        public int? Bus { get; set; }
        /// <summary> Gets or sets the disk lun. </summary>
        public int? Lun { get; set; }
        /// <summary> Gets or sets the disk bus type. </summary>
        public string BusType { get; set; }
        /// <summary> Gets or sets the disk vhd type. </summary>
        public string VhdType { get; set; }
        /// <summary> Gets the disk volume type. </summary>
        public string VolumeType { get; }
        /// <summary> Gets the disk vhd format type. </summary>
        public string VhdFormatType { get; }
        /// <summary> Gets or sets the disk id in the template. </summary>
        public string TemplateDiskId { get; set; }
        /// <summary> The QoS policy for the disk. </summary>
        public ScVmmStorageQosPolicyDetails StorageQosPolicy { get; set; }
        /// <summary> Gets or sets a value indicating diff disk. </summary>
        public CreateDiffDisk? CreateDiffDisk { get; set; }
    }
}
