// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm.Models
{
    public partial class ScVmmVirtualDisk : IUtf8JsonSerializable, IJsonModel<ScVmmVirtualDisk>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScVmmVirtualDisk>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScVmmVirtualDisk>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmVirtualDisk>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmVirtualDisk)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (options.Format != "W" && Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (Optional.IsDefined(DiskId))
            {
                writer.WritePropertyName("diskId"u8);
                writer.WriteStringValue(DiskId);
            }
            if (Optional.IsDefined(DiskSizeGB))
            {
                writer.WritePropertyName("diskSizeGB"u8);
                writer.WriteNumberValue(DiskSizeGB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxDiskSizeGB))
            {
                writer.WritePropertyName("maxDiskSizeGB"u8);
                writer.WriteNumberValue(MaxDiskSizeGB.Value);
            }
            if (Optional.IsDefined(Bus))
            {
                writer.WritePropertyName("bus"u8);
                writer.WriteNumberValue(Bus.Value);
            }
            if (Optional.IsDefined(Lun))
            {
                writer.WritePropertyName("lun"u8);
                writer.WriteNumberValue(Lun.Value);
            }
            if (Optional.IsDefined(BusType))
            {
                writer.WritePropertyName("busType"u8);
                writer.WriteStringValue(BusType);
            }
            if (Optional.IsDefined(VhdType))
            {
                writer.WritePropertyName("vhdType"u8);
                writer.WriteStringValue(VhdType);
            }
            if (options.Format != "W" && Optional.IsDefined(VolumeType))
            {
                writer.WritePropertyName("volumeType"u8);
                writer.WriteStringValue(VolumeType);
            }
            if (options.Format != "W" && Optional.IsDefined(VhdFormatType))
            {
                writer.WritePropertyName("vhdFormatType"u8);
                writer.WriteStringValue(VhdFormatType);
            }
            if (Optional.IsDefined(TemplateDiskId))
            {
                writer.WritePropertyName("templateDiskId"u8);
                writer.WriteStringValue(TemplateDiskId);
            }
            if (Optional.IsDefined(StorageQosPolicy))
            {
                writer.WritePropertyName("storageQoSPolicy"u8);
                writer.WriteObjectValue(StorageQosPolicy, options);
            }
            if (Optional.IsDefined(CreateDiffDisk))
            {
                writer.WritePropertyName("createDiffDisk"u8);
                writer.WriteStringValue(CreateDiffDisk.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScVmmVirtualDisk IJsonModel<ScVmmVirtualDisk>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmVirtualDisk>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmVirtualDisk)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScVmmVirtualDisk(document.RootElement, options);
        }

        internal static ScVmmVirtualDisk DeserializeScVmmVirtualDisk(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string displayName = default;
            string diskId = default;
            int? diskSizeGB = default;
            int? maxDiskSizeGB = default;
            int? bus = default;
            int? lun = default;
            string busType = default;
            string vhdType = default;
            string volumeType = default;
            string vhdFormatType = default;
            string templateDiskId = default;
            ScVmmStorageQosPolicyDetails storageQosPolicy = default;
            CreateDiffDisk? createDiffDisk = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("diskId"u8))
                {
                    diskId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("diskSizeGB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskSizeGB = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxDiskSizeGB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxDiskSizeGB = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("bus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bus = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("lun"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lun = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("busType"u8))
                {
                    busType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vhdType"u8))
                {
                    vhdType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("volumeType"u8))
                {
                    volumeType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vhdFormatType"u8))
                {
                    vhdFormatType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("templateDiskId"u8))
                {
                    templateDiskId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("storageQoSPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageQosPolicy = ScVmmStorageQosPolicyDetails.DeserializeScVmmStorageQosPolicyDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("createDiffDisk"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    createDiffDisk = new CreateDiffDisk(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScVmmVirtualDisk(
                name,
                displayName,
                diskId,
                diskSizeGB,
                maxDiskSizeGB,
                bus,
                lun,
                busType,
                vhdType,
                volumeType,
                vhdFormatType,
                templateDiskId,
                storageQosPolicy,
                createDiffDisk,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScVmmVirtualDisk>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmVirtualDisk>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScVmmVirtualDisk)} does not support writing '{options.Format}' format.");
            }
        }

        ScVmmVirtualDisk IPersistableModel<ScVmmVirtualDisk>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmVirtualDisk>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScVmmVirtualDisk(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScVmmVirtualDisk)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScVmmVirtualDisk>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
