// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> The StorageQoSPolicy definition. </summary>
    public partial class ScVmmStorageQosPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScVmmStorageQosPolicy"/>. </summary>
        internal ScVmmStorageQosPolicy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ScVmmStorageQosPolicy"/>. </summary>
        /// <param name="name"> The name of the policy. </param>
        /// <param name="id"> The ID of the QoS policy. </param>
        /// <param name="iopsMaximum"> The maximum IO operations per second. </param>
        /// <param name="iopsMinimum"> The minimum IO operations per second. </param>
        /// <param name="bandwidthLimit"> The Bandwidth Limit for internet traffic. </param>
        /// <param name="policyId"> The underlying policy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScVmmStorageQosPolicy(string name, string id, long? iopsMaximum, long? iopsMinimum, long? bandwidthLimit, string policyId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Id = id;
            IopsMaximum = iopsMaximum;
            IopsMinimum = iopsMinimum;
            BandwidthLimit = bandwidthLimit;
            PolicyId = policyId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the policy. </summary>
        public string Name { get; }
        /// <summary> The ID of the QoS policy. </summary>
        public string Id { get; }
        /// <summary> The maximum IO operations per second. </summary>
        public long? IopsMaximum { get; }
        /// <summary> The minimum IO operations per second. </summary>
        public long? IopsMinimum { get; }
        /// <summary> The Bandwidth Limit for internet traffic. </summary>
        public long? BandwidthLimit { get; }
        /// <summary> The underlying policy. </summary>
        public string PolicyId { get; }
    }
}
