// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> Defines the different types of operations for guest agent. </summary>
    public readonly partial struct ScVmmProvisioningAction : IEquatable<ScVmmProvisioningAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScVmmProvisioningAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScVmmProvisioningAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InstallValue = "install";
        private const string UninstallValue = "uninstall";
        private const string RepairValue = "repair";

        /// <summary> install. </summary>
        public static ScVmmProvisioningAction Install { get; } = new ScVmmProvisioningAction(InstallValue);
        /// <summary> uninstall. </summary>
        public static ScVmmProvisioningAction Uninstall { get; } = new ScVmmProvisioningAction(UninstallValue);
        /// <summary> repair. </summary>
        public static ScVmmProvisioningAction Repair { get; } = new ScVmmProvisioningAction(RepairValue);
        /// <summary> Determines if two <see cref="ScVmmProvisioningAction"/> values are the same. </summary>
        public static bool operator ==(ScVmmProvisioningAction left, ScVmmProvisioningAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScVmmProvisioningAction"/> values are not the same. </summary>
        public static bool operator !=(ScVmmProvisioningAction left, ScVmmProvisioningAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScVmmProvisioningAction"/>. </summary>
        public static implicit operator ScVmmProvisioningAction(string value) => new ScVmmProvisioningAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScVmmProvisioningAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScVmmProvisioningAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
