// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm.Models
{
    public partial class ScVmmNetworkInterfaceUpdate : IUtf8JsonSerializable, IJsonModel<ScVmmNetworkInterfaceUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScVmmNetworkInterfaceUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScVmmNetworkInterfaceUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmNetworkInterfaceUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmNetworkInterfaceUpdate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(MacAddress))
            {
                writer.WritePropertyName("macAddress"u8);
                writer.WriteStringValue(MacAddress);
            }
            if (Optional.IsDefined(VirtualNetworkId))
            {
                writer.WritePropertyName("virtualNetworkId"u8);
                writer.WriteStringValue(VirtualNetworkId);
            }
            if (Optional.IsDefined(IPv4AddressType))
            {
                writer.WritePropertyName("ipv4AddressType"u8);
                writer.WriteStringValue(IPv4AddressType.Value.ToString());
            }
            if (Optional.IsDefined(IPv6AddressType))
            {
                writer.WritePropertyName("ipv6AddressType"u8);
                writer.WriteStringValue(IPv6AddressType.Value.ToString());
            }
            if (Optional.IsDefined(MacAddressType))
            {
                writer.WritePropertyName("macAddressType"u8);
                writer.WriteStringValue(MacAddressType.Value.ToString());
            }
            if (Optional.IsDefined(NicId))
            {
                writer.WritePropertyName("nicId"u8);
                writer.WriteStringValue(NicId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScVmmNetworkInterfaceUpdate IJsonModel<ScVmmNetworkInterfaceUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmNetworkInterfaceUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmNetworkInterfaceUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScVmmNetworkInterfaceUpdate(document.RootElement, options);
        }

        internal static ScVmmNetworkInterfaceUpdate DeserializeScVmmNetworkInterfaceUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string macAddress = default;
            string virtualNetworkId = default;
            AllocationMethod? ipv4AddressType = default;
            AllocationMethod? ipv6AddressType = default;
            AllocationMethod? macAddressType = default;
            string nicId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("macAddress"u8))
                {
                    macAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("virtualNetworkId"u8))
                {
                    virtualNetworkId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ipv4AddressType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ipv4AddressType = new AllocationMethod(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("ipv6AddressType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ipv6AddressType = new AllocationMethod(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("macAddressType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    macAddressType = new AllocationMethod(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("nicId"u8))
                {
                    nicId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScVmmNetworkInterfaceUpdate(
                name,
                macAddress,
                virtualNetworkId,
                ipv4AddressType,
                ipv6AddressType,
                macAddressType,
                nicId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScVmmNetworkInterfaceUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmNetworkInterfaceUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScVmmNetworkInterfaceUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        ScVmmNetworkInterfaceUpdate IPersistableModel<ScVmmNetworkInterfaceUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmNetworkInterfaceUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScVmmNetworkInterfaceUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScVmmNetworkInterfaceUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScVmmNetworkInterfaceUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
