// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> The inventory type. </summary>
    internal readonly partial struct ScVmmInventoryType : IEquatable<ScVmmInventoryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScVmmInventoryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScVmmInventoryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CloudValue = "Cloud";
        private const string VirtualNetworkValue = "VirtualNetwork";
        private const string VirtualMachineTemplateValue = "VirtualMachineTemplate";
        private const string VirtualMachineValue = "VirtualMachine";

        /// <summary> Cloud. </summary>
        public static ScVmmInventoryType Cloud { get; } = new ScVmmInventoryType(CloudValue);
        /// <summary> VirtualNetwork. </summary>
        public static ScVmmInventoryType VirtualNetwork { get; } = new ScVmmInventoryType(VirtualNetworkValue);
        /// <summary> VirtualMachineTemplate. </summary>
        public static ScVmmInventoryType VirtualMachineTemplate { get; } = new ScVmmInventoryType(VirtualMachineTemplateValue);
        /// <summary> VirtualMachine. </summary>
        public static ScVmmInventoryType VirtualMachine { get; } = new ScVmmInventoryType(VirtualMachineValue);
        /// <summary> Determines if two <see cref="ScVmmInventoryType"/> values are the same. </summary>
        public static bool operator ==(ScVmmInventoryType left, ScVmmInventoryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScVmmInventoryType"/> values are not the same. </summary>
        public static bool operator !=(ScVmmInventoryType left, ScVmmInventoryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScVmmInventoryType"/>. </summary>
        public static implicit operator ScVmmInventoryType(string value) => new ScVmmInventoryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScVmmInventoryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScVmmInventoryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
