// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm.Models
{
    [PersistableModelProxy(typeof(UnknownInventoryItemProperties))]
    public partial class ScVmmInventoryItemProperties : IUtf8JsonSerializable, IJsonModel<ScVmmInventoryItemProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScVmmInventoryItemProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScVmmInventoryItemProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmInventoryItemProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmInventoryItemProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("inventoryType"u8);
            writer.WriteStringValue(InventoryType.ToString());
            if (options.Format != "W" && Optional.IsDefined(ManagedResourceId))
            {
                writer.WritePropertyName("managedResourceId"u8);
                writer.WriteStringValue(ManagedResourceId);
            }
            if (options.Format != "W" && Optional.IsDefined(Uuid))
            {
                writer.WritePropertyName("uuid"u8);
                writer.WriteStringValue(Uuid);
            }
            if (options.Format != "W" && Optional.IsDefined(InventoryItemName))
            {
                writer.WritePropertyName("inventoryItemName"u8);
                writer.WriteStringValue(InventoryItemName);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScVmmInventoryItemProperties IJsonModel<ScVmmInventoryItemProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmInventoryItemProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmInventoryItemProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScVmmInventoryItemProperties(document.RootElement, options);
        }

        internal static ScVmmInventoryItemProperties DeserializeScVmmInventoryItemProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("inventoryType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Cloud": return CloudInventoryItem.DeserializeCloudInventoryItem(element, options);
                    case "VirtualMachine": return VirtualMachineInventoryItem.DeserializeVirtualMachineInventoryItem(element, options);
                    case "VirtualMachineTemplate": return VirtualMachineTemplateInventoryItem.DeserializeVirtualMachineTemplateInventoryItem(element, options);
                    case "VirtualNetwork": return VirtualNetworkInventoryItem.DeserializeVirtualNetworkInventoryItem(element, options);
                }
            }
            return UnknownInventoryItemProperties.DeserializeUnknownInventoryItemProperties(element, options);
        }

        BinaryData IPersistableModel<ScVmmInventoryItemProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmInventoryItemProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScVmmInventoryItemProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ScVmmInventoryItemProperties IPersistableModel<ScVmmInventoryItemProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmInventoryItemProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScVmmInventoryItemProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScVmmInventoryItemProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScVmmInventoryItemProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
