// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm.Models
{
    public partial class ScVmmInfrastructureProfile : IUtf8JsonSerializable, IJsonModel<ScVmmInfrastructureProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScVmmInfrastructureProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScVmmInfrastructureProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmInfrastructureProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmInfrastructureProfile)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(InventoryItemId))
            {
                writer.WritePropertyName("inventoryItemId"u8);
                writer.WriteStringValue(InventoryItemId);
            }
            if (Optional.IsDefined(VmmServerId))
            {
                writer.WritePropertyName("vmmServerId"u8);
                writer.WriteStringValue(VmmServerId);
            }
            if (Optional.IsDefined(CloudId))
            {
                writer.WritePropertyName("cloudId"u8);
                writer.WriteStringValue(CloudId);
            }
            if (Optional.IsDefined(TemplateId))
            {
                writer.WritePropertyName("templateId"u8);
                writer.WriteStringValue(TemplateId);
            }
            if (Optional.IsDefined(VmName))
            {
                writer.WritePropertyName("vmName"u8);
                writer.WriteStringValue(VmName);
            }
            if (Optional.IsDefined(Uuid))
            {
                writer.WritePropertyName("uuid"u8);
                writer.WriteStringValue(Uuid);
            }
            if (options.Format != "W" && Optional.IsDefined(LastRestoredVmCheckpoint))
            {
                writer.WritePropertyName("lastRestoredVMCheckpoint"u8);
                writer.WriteObjectValue(LastRestoredVmCheckpoint, options);
            }
            if (Optional.IsCollectionDefined(Checkpoints))
            {
                writer.WritePropertyName("checkpoints"u8);
                writer.WriteStartArray();
                foreach (var item in Checkpoints)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(CheckpointType))
            {
                writer.WritePropertyName("checkpointType"u8);
                writer.WriteStringValue(CheckpointType);
            }
            if (Optional.IsDefined(Generation))
            {
                writer.WritePropertyName("generation"u8);
                writer.WriteNumberValue(Generation.Value);
            }
            if (Optional.IsDefined(BiosGuid))
            {
                writer.WritePropertyName("biosGuid"u8);
                writer.WriteStringValue(BiosGuid);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScVmmInfrastructureProfile IJsonModel<ScVmmInfrastructureProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmInfrastructureProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScVmmInfrastructureProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScVmmInfrastructureProfile(document.RootElement, options);
        }

        internal static ScVmmInfrastructureProfile DeserializeScVmmInfrastructureProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string inventoryItemId = default;
            ResourceIdentifier vmmServerId = default;
            ResourceIdentifier cloudId = default;
            ResourceIdentifier templateId = default;
            string vmName = default;
            string uuid = default;
            ScVmmCheckpoint lastRestoredVmCheckpoint = default;
            IList<ScVmmCheckpoint> checkpoints = default;
            string checkpointType = default;
            int? generation = default;
            string biosGuid = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("inventoryItemId"u8))
                {
                    inventoryItemId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vmmServerId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vmmServerId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("cloudId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("templateId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    templateId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("vmName"u8))
                {
                    vmName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("uuid"u8))
                {
                    uuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastRestoredVMCheckpoint"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastRestoredVmCheckpoint = ScVmmCheckpoint.DeserializeScVmmCheckpoint(property.Value, options);
                    continue;
                }
                if (property.NameEquals("checkpoints"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ScVmmCheckpoint> array = new List<ScVmmCheckpoint>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ScVmmCheckpoint.DeserializeScVmmCheckpoint(item, options));
                    }
                    checkpoints = array;
                    continue;
                }
                if (property.NameEquals("checkpointType"u8))
                {
                    checkpointType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("generation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    generation = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("biosGuid"u8))
                {
                    biosGuid = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScVmmInfrastructureProfile(
                inventoryItemId,
                vmmServerId,
                cloudId,
                templateId,
                vmName,
                uuid,
                lastRestoredVmCheckpoint,
                checkpoints ?? new ChangeTrackingList<ScVmmCheckpoint>(),
                checkpointType,
                generation,
                biosGuid,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScVmmInfrastructureProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmInfrastructureProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScVmmInfrastructureProfile)} does not support writing '{options.Format}' format.");
            }
        }

        ScVmmInfrastructureProfile IPersistableModel<ScVmmInfrastructureProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScVmmInfrastructureProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScVmmInfrastructureProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScVmmInfrastructureProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScVmmInfrastructureProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
