// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> The ScVmmForceDeletion. </summary>
    public readonly partial struct ScVmmForceDeletion : IEquatable<ScVmmForceDeletion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScVmmForceDeletion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScVmmForceDeletion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "false";
        private const string TrueValue = "true";

        /// <summary> false. </summary>
        public static ScVmmForceDeletion False { get; } = new ScVmmForceDeletion(FalseValue);
        /// <summary> true. </summary>
        public static ScVmmForceDeletion True { get; } = new ScVmmForceDeletion(TrueValue);
        /// <summary> Determines if two <see cref="ScVmmForceDeletion"/> values are the same. </summary>
        public static bool operator ==(ScVmmForceDeletion left, ScVmmForceDeletion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScVmmForceDeletion"/> values are not the same. </summary>
        public static bool operator !=(ScVmmForceDeletion left, ScVmmForceDeletion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScVmmForceDeletion"/>. </summary>
        public static implicit operator ScVmmForceDeletion(string value) => new ScVmmForceDeletion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScVmmForceDeletion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScVmmForceDeletion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
