// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> Gets highly available property. </summary>
    public readonly partial struct IsHighlyAvailable : IEquatable<IsHighlyAvailable>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IsHighlyAvailable"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IsHighlyAvailable(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "false";
        private const string TrueValue = "true";

        /// <summary> false. </summary>
        public static IsHighlyAvailable False { get; } = new IsHighlyAvailable(FalseValue);
        /// <summary> true. </summary>
        public static IsHighlyAvailable True { get; } = new IsHighlyAvailable(TrueValue);
        /// <summary> Determines if two <see cref="IsHighlyAvailable"/> values are the same. </summary>
        public static bool operator ==(IsHighlyAvailable left, IsHighlyAvailable right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IsHighlyAvailable"/> values are not the same. </summary>
        public static bool operator !=(IsHighlyAvailable left, IsHighlyAvailable right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IsHighlyAvailable"/>. </summary>
        public static implicit operator IsHighlyAvailable(string value) => new IsHighlyAvailable(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IsHighlyAvailable other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IsHighlyAvailable other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
