// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> Gets a value indicating whether the vm template is customizable or not. </summary>
    public readonly partial struct IsCustomizable : IEquatable<IsCustomizable>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IsCustomizable"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IsCustomizable(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "false";
        private const string TrueValue = "true";

        /// <summary> false. </summary>
        public static IsCustomizable False { get; } = new IsCustomizable(FalseValue);
        /// <summary> true. </summary>
        public static IsCustomizable True { get; } = new IsCustomizable(TrueValue);
        /// <summary> Determines if two <see cref="IsCustomizable"/> values are the same. </summary>
        public static bool operator ==(IsCustomizable left, IsCustomizable right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IsCustomizable"/> values are not the same. </summary>
        public static bool operator !=(IsCustomizable left, IsCustomizable right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IsCustomizable"/>. </summary>
        public static implicit operator IsCustomizable(string value) => new IsCustomizable(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IsCustomizable other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IsCustomizable other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
