// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> Gets or sets a value indicating whether to enable dynamic memory or not. </summary>
    public readonly partial struct DynamicMemoryEnabled : IEquatable<DynamicMemoryEnabled>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynamicMemoryEnabled"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynamicMemoryEnabled(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "false";
        private const string TrueValue = "true";

        /// <summary> false. </summary>
        public static DynamicMemoryEnabled False { get; } = new DynamicMemoryEnabled(FalseValue);
        /// <summary> true. </summary>
        public static DynamicMemoryEnabled True { get; } = new DynamicMemoryEnabled(TrueValue);
        /// <summary> Determines if two <see cref="DynamicMemoryEnabled"/> values are the same. </summary>
        public static bool operator ==(DynamicMemoryEnabled left, DynamicMemoryEnabled right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynamicMemoryEnabled"/> values are not the same. </summary>
        public static bool operator !=(DynamicMemoryEnabled left, DynamicMemoryEnabled right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynamicMemoryEnabled"/>. </summary>
        public static implicit operator DynamicMemoryEnabled(string value) => new DynamicMemoryEnabled(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynamicMemoryEnabled other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynamicMemoryEnabled other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
