// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> The DeleteFromHost. </summary>
    public readonly partial struct DeleteFromHost : IEquatable<DeleteFromHost>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeleteFromHost"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeleteFromHost(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "false";
        private const string TrueValue = "true";

        /// <summary> false. </summary>
        public static DeleteFromHost False { get; } = new DeleteFromHost(FalseValue);
        /// <summary> true. </summary>
        public static DeleteFromHost True { get; } = new DeleteFromHost(TrueValue);
        /// <summary> Determines if two <see cref="DeleteFromHost"/> values are the same. </summary>
        public static bool operator ==(DeleteFromHost left, DeleteFromHost right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeleteFromHost"/> values are not the same. </summary>
        public static bool operator !=(DeleteFromHost left, DeleteFromHost right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeleteFromHost"/>. </summary>
        public static implicit operator DeleteFromHost(string value) => new DeleteFromHost(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeleteFromHost other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeleteFromHost other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
