// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ScVmm.Models
{
    /// <summary> Gets or sets a value indicating diff disk. </summary>
    public readonly partial struct CreateDiffDisk : IEquatable<CreateDiffDisk>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CreateDiffDisk"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CreateDiffDisk(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "false";
        private const string TrueValue = "true";

        /// <summary> false. </summary>
        public static CreateDiffDisk False { get; } = new CreateDiffDisk(FalseValue);
        /// <summary> true. </summary>
        public static CreateDiffDisk True { get; } = new CreateDiffDisk(TrueValue);
        /// <summary> Determines if two <see cref="CreateDiffDisk"/> values are the same. </summary>
        public static bool operator ==(CreateDiffDisk left, CreateDiffDisk right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CreateDiffDisk"/> values are not the same. </summary>
        public static bool operator !=(CreateDiffDisk left, CreateDiffDisk right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CreateDiffDisk"/>. </summary>
        public static implicit operator CreateDiffDisk(string value) => new CreateDiffDisk(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CreateDiffDisk other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CreateDiffDisk other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
