// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm.Models
{
    public partial class CloudInventoryItem : IUtf8JsonSerializable, IJsonModel<CloudInventoryItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CloudInventoryItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CloudInventoryItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudInventoryItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CloudInventoryItem)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        CloudInventoryItem IJsonModel<CloudInventoryItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudInventoryItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CloudInventoryItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCloudInventoryItem(document.RootElement, options);
        }

        internal static CloudInventoryItem DeserializeCloudInventoryItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ScVmmInventoryType inventoryType = default;
            string managedResourceId = default;
            string uuid = default;
            string inventoryItemName = default;
            ScVmmProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("inventoryType"u8))
                {
                    inventoryType = new ScVmmInventoryType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("managedResourceId"u8))
                {
                    managedResourceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("uuid"u8))
                {
                    uuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("inventoryItemName"u8))
                {
                    inventoryItemName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new ScVmmProvisioningState(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CloudInventoryItem(
                inventoryType,
                managedResourceId,
                uuid,
                inventoryItemName,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CloudInventoryItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudInventoryItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CloudInventoryItem)} does not support writing '{options.Format}' format.");
            }
        }

        CloudInventoryItem IPersistableModel<CloudInventoryItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudInventoryItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCloudInventoryItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CloudInventoryItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CloudInventoryItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
