// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm
{
    internal class ScVmmVirtualMachineTemplateOperationSource : IOperationSource<ScVmmVirtualMachineTemplateResource>
    {
        private readonly ArmClient _client;

        internal ScVmmVirtualMachineTemplateOperationSource(ArmClient client)
        {
            _client = client;
        }

        ScVmmVirtualMachineTemplateResource IOperationSource<ScVmmVirtualMachineTemplateResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ScVmmVirtualMachineTemplateData.DeserializeScVmmVirtualMachineTemplateData(document.RootElement);
            return new ScVmmVirtualMachineTemplateResource(_client, data);
        }

        async ValueTask<ScVmmVirtualMachineTemplateResource> IOperationSource<ScVmmVirtualMachineTemplateResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ScVmmVirtualMachineTemplateData.DeserializeScVmmVirtualMachineTemplateData(document.RootElement);
            return new ScVmmVirtualMachineTemplateResource(_client, data);
        }
    }
}
