// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm
{
    internal class ScVmmGuestAgentOperationSource : IOperationSource<ScVmmGuestAgentResource>
    {
        private readonly ArmClient _client;

        internal ScVmmGuestAgentOperationSource(ArmClient client)
        {
            _client = client;
        }

        ScVmmGuestAgentResource IOperationSource<ScVmmGuestAgentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ScVmmGuestAgentData.DeserializeScVmmGuestAgentData(document.RootElement);
            return new ScVmmGuestAgentResource(_client, data);
        }

        async ValueTask<ScVmmGuestAgentResource> IOperationSource<ScVmmGuestAgentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ScVmmGuestAgentData.DeserializeScVmmGuestAgentData(document.RootElement);
            return new ScVmmGuestAgentResource(_client, data);
        }
    }
}
