// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ScVmm
{
    internal class ScVmmAvailabilitySetOperationSource : IOperationSource<ScVmmAvailabilitySetResource>
    {
        private readonly ArmClient _client;

        internal ScVmmAvailabilitySetOperationSource(ArmClient client)
        {
            _client = client;
        }

        ScVmmAvailabilitySetResource IOperationSource<ScVmmAvailabilitySetResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ScVmmAvailabilitySetData.DeserializeScVmmAvailabilitySetData(document.RootElement);
            return new ScVmmAvailabilitySetResource(_client, data);
        }

        async ValueTask<ScVmmAvailabilitySetResource> IOperationSource<ScVmmAvailabilitySetResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ScVmmAvailabilitySetData.DeserializeScVmmAvailabilitySetData(document.RootElement);
            return new ScVmmAvailabilitySetResource(_client, data);
        }
    }
}
