// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ScVmm.Models;

namespace Azure.ResourceManager.ScVmm.Samples
{
    public partial class Sample_ScVmmGuestAgentResource
    {
        // CreateGuestAgent
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateGuestAgent()
        {
            // Generated from example definition: specification/scvmm/resource-manager/Microsoft.ScVmm/stable/2023-10-07/examples/CreateVMInstanceGuestAgent.json
            // this example is just showing the usage of "VMInstanceGuestAgents_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScVmmGuestAgentResource created on azure
            // for more information of creating ScVmmGuestAgentResource, please refer to the document of ScVmmGuestAgentResource
            string resourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM";
            ResourceIdentifier scVmmGuestAgentResourceId = ScVmmGuestAgentResource.CreateResourceIdentifier(resourceUri);
            ScVmmGuestAgentResource scVmmGuestAgent = client.GetScVmmGuestAgentResource(scVmmGuestAgentResourceId);

            // invoke the operation
            ScVmmGuestAgentData data = new ScVmmGuestAgentData()
            {
                Credentials = new ScVmmGuestCredential("tempuser", "<password>"),
                HttpsProxy = "http://192.1.2.3:8080",
                ProvisioningAction = ScVmmProvisioningAction.Install,
            };
            ArmOperation<ScVmmGuestAgentResource> lro = await scVmmGuestAgent.CreateOrUpdateAsync(WaitUntil.Completed, data);
            ScVmmGuestAgentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ScVmmGuestAgentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetGuestAgent
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetGuestAgent()
        {
            // Generated from example definition: specification/scvmm/resource-manager/Microsoft.ScVmm/stable/2023-10-07/examples/GetVMInstanceGuestAgent.json
            // this example is just showing the usage of "VMInstanceGuestAgents_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScVmmGuestAgentResource created on azure
            // for more information of creating ScVmmGuestAgentResource, please refer to the document of ScVmmGuestAgentResource
            string resourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM";
            ResourceIdentifier scVmmGuestAgentResourceId = ScVmmGuestAgentResource.CreateResourceIdentifier(resourceUri);
            ScVmmGuestAgentResource scVmmGuestAgent = client.GetScVmmGuestAgentResource(scVmmGuestAgentResourceId);

            // invoke the operation
            ScVmmGuestAgentResource result = await scVmmGuestAgent.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ScVmmGuestAgentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeleteGuestAgent
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteGuestAgent()
        {
            // Generated from example definition: specification/scvmm/resource-manager/Microsoft.ScVmm/stable/2023-10-07/examples/DeleteVMInstanceGuestAgent.json
            // this example is just showing the usage of "VMInstanceGuestAgents_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScVmmGuestAgentResource created on azure
            // for more information of creating ScVmmGuestAgentResource, please refer to the document of ScVmmGuestAgentResource
            string resourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM";
            ResourceIdentifier scVmmGuestAgentResourceId = ScVmmGuestAgentResource.CreateResourceIdentifier(resourceUri);
            ScVmmGuestAgentResource scVmmGuestAgent = client.GetScVmmGuestAgentResource(scVmmGuestAgentResourceId);

            // invoke the operation
            await scVmmGuestAgent.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
