// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager;
using Azure.ResourceManager.AppPlatform;
using Azure.ResourceManager.AppPlatform.Models;

namespace Azure.ResourceManager.AppPlatform.Samples
{
    public partial class Sample_AppPlatformStorageResource
    {
        // Storages_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_StoragesGet()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Storages_Get.json
            // this example is just showing the usage of "Storages_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformStorageResource created on azure
            // for more information of creating AppPlatformStorageResource, please refer to the document of AppPlatformStorageResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string storageName = "mystorage";
            ResourceIdentifier appPlatformStorageResourceId = AppPlatformStorageResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, storageName);
            AppPlatformStorageResource appPlatformStorage = client.GetAppPlatformStorageResource(appPlatformStorageResourceId);

            // invoke the operation
            AppPlatformStorageResource result = await appPlatformStorage.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformStorageData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Storages_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_StoragesCreateOrUpdate()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Storages_CreateOrUpdate.json
            // this example is just showing the usage of "Storages_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformStorageResource created on azure
            // for more information of creating AppPlatformStorageResource, please refer to the document of AppPlatformStorageResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string storageName = "mystorage";
            ResourceIdentifier appPlatformStorageResourceId = AppPlatformStorageResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, storageName);
            AppPlatformStorageResource appPlatformStorage = client.GetAppPlatformStorageResource(appPlatformStorageResourceId);

            // invoke the operation
            AppPlatformStorageData data = new AppPlatformStorageData()
            {
                Properties = new AppPlatformStorageAccount("storage-account-name", "account-key-of-storage-account"),
            };
            ArmOperation<AppPlatformStorageResource> lro = await appPlatformStorage.UpdateAsync(WaitUntil.Completed, data);
            AppPlatformStorageResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformStorageData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Storages_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_StoragesDelete()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Storages_Delete.json
            // this example is just showing the usage of "Storages_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformStorageResource created on azure
            // for more information of creating AppPlatformStorageResource, please refer to the document of AppPlatformStorageResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string storageName = "mystorage";
            ResourceIdentifier appPlatformStorageResourceId = AppPlatformStorageResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, storageName);
            AppPlatformStorageResource appPlatformStorage = client.GetAppPlatformStorageResource(appPlatformStorageResourceId);

            // invoke the operation
            await appPlatformStorage.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
