// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Unknown version of UserSourceInfo. </summary>
    internal partial class UnknownUserSourceInfo : AppPlatformUserSourceInfo
    {
        /// <summary> Initializes a new instance of <see cref="UnknownUserSourceInfo"/>. </summary>
        /// <param name="userSourceInfoType"> Type of the source uploaded. </param>
        /// <param name="version"> Version of the source. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownUserSourceInfo(string userSourceInfoType, string version, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(userSourceInfoType, version, serializedAdditionalRawData)
        {
            UserSourceInfoType = userSourceInfoType ?? "Unknown";
        }

        /// <summary> Initializes a new instance of <see cref="UnknownUserSourceInfo"/> for deserialization. </summary>
        internal UnknownUserSourceInfo()
        {
        }
    }
}
