// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> The type of the storage. </summary>
    internal readonly partial struct StorageType : IEquatable<StorageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StorageAccountValue = "StorageAccount";

        /// <summary> StorageAccount. </summary>
        public static StorageType StorageAccount { get; } = new StorageType(StorageAccountValue);
        /// <summary> Determines if two <see cref="StorageType"/> values are the same. </summary>
        public static bool operator ==(StorageType left, StorageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageType"/> values are not the same. </summary>
        public static bool operator !=(StorageType left, StorageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageType"/>. </summary>
        public static implicit operator StorageType(string value) => new StorageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
