// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Uploaded Java source code binary for a deployment. </summary>
    public partial class SourceUploadedUserSourceInfo : AppPlatformUploadedUserSourceInfo
    {
        /// <summary> Initializes a new instance of <see cref="SourceUploadedUserSourceInfo"/>. </summary>
        public SourceUploadedUserSourceInfo()
        {
            UserSourceInfoType = "Source";
        }

        /// <summary> Initializes a new instance of <see cref="SourceUploadedUserSourceInfo"/>. </summary>
        /// <param name="userSourceInfoType"> Type of the source uploaded. </param>
        /// <param name="version"> Version of the source. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="relativePath"> Relative path of the storage which stores the source. </param>
        /// <param name="artifactSelector">
        /// Selector for the artifact to be used for the deployment for multi-module projects. This should be
        /// the relative path to the target module/project.
        /// </param>
        /// <param name="runtimeVersion"> Runtime version of the source file. </param>
        internal SourceUploadedUserSourceInfo(string userSourceInfoType, string version, IDictionary<string, BinaryData> serializedAdditionalRawData, string relativePath, string artifactSelector, string runtimeVersion) : base(userSourceInfoType, version, serializedAdditionalRawData, relativePath)
        {
            ArtifactSelector = artifactSelector;
            RuntimeVersion = runtimeVersion;
            UserSourceInfoType = userSourceInfoType ?? "Source";
        }

        /// <summary>
        /// Selector for the artifact to be used for the deployment for multi-module projects. This should be
        /// the relative path to the target module/project.
        /// </summary>
        public string ArtifactSelector { get; set; }
        /// <summary> Runtime version of the source file. </summary>
        public string RuntimeVersion { get; set; }
    }
}
