// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Desired outbound IP resources for Azure Spring Apps resource. </summary>
    internal partial class NetworkProfileOutboundIPs
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkProfileOutboundIPs"/>. </summary>
        internal NetworkProfileOutboundIPs()
        {
            PublicIPs = new ChangeTrackingList<IPAddress>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkProfileOutboundIPs"/>. </summary>
        /// <param name="publicIPs"> A list of public IP addresses. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkProfileOutboundIPs(IReadOnlyList<IPAddress> publicIPs, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublicIPs = publicIPs;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A list of public IP addresses. </summary>
        public IReadOnlyList<IPAddress> PublicIPs { get; }
    }
}
