// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> The provisioning state of this build stage resource. </summary>
    public readonly partial struct KPackBuildStageProvisioningState : IEquatable<KPackBuildStageProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KPackBuildStageProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KPackBuildStageProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string RunningValue = "Running";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> NotStarted. </summary>
        public static KPackBuildStageProvisioningState NotStarted { get; } = new KPackBuildStageProvisioningState(NotStartedValue);
        /// <summary> Running. </summary>
        public static KPackBuildStageProvisioningState Running { get; } = new KPackBuildStageProvisioningState(RunningValue);
        /// <summary> Succeeded. </summary>
        public static KPackBuildStageProvisioningState Succeeded { get; } = new KPackBuildStageProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static KPackBuildStageProvisioningState Failed { get; } = new KPackBuildStageProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="KPackBuildStageProvisioningState"/> values are the same. </summary>
        public static bool operator ==(KPackBuildStageProvisioningState left, KPackBuildStageProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KPackBuildStageProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(KPackBuildStageProvisioningState left, KPackBuildStageProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KPackBuildStageProvisioningState"/>. </summary>
        public static implicit operator KPackBuildStageProvisioningState(string value) => new KPackBuildStageProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KPackBuildStageProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KPackBuildStageProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
