// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Property of git environment. </summary>
    internal partial class ConfigurationServiceGitProperty
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConfigurationServiceGitProperty"/>. </summary>
        public ConfigurationServiceGitProperty()
        {
            ConfigurationServiceGitRepositories = new ChangeTrackingList<AppPlatformConfigurationServiceGitRepository>();
        }

        /// <summary> Initializes a new instance of <see cref="ConfigurationServiceGitProperty"/>. </summary>
        /// <param name="configurationServiceGitRepositories"> Repositories of Application Configuration Service git property. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConfigurationServiceGitProperty(IList<AppPlatformConfigurationServiceGitRepository> configurationServiceGitRepositories, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ConfigurationServiceGitRepositories = configurationServiceGitRepositories;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Repositories of Application Configuration Service git property. </summary>
        public IList<AppPlatformConfigurationServiceGitRepository> ConfigurationServiceGitRepositories { get; }
    }
}
