// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Buildpack Binding Type. </summary>
    public readonly partial struct BuildpackBindingType : IEquatable<BuildpackBindingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BuildpackBindingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BuildpackBindingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApplicationInsightsValue = "ApplicationInsights";
        private const string ApacheSkyWalkingValue = "ApacheSkyWalking";
        private const string AppDynamicsValue = "AppDynamics";
        private const string DynatraceValue = "Dynatrace";
        private const string NewRelicValue = "NewRelic";
        private const string ElasticApmValue = "ElasticAPM";

        /// <summary> ApplicationInsights. </summary>
        public static BuildpackBindingType ApplicationInsights { get; } = new BuildpackBindingType(ApplicationInsightsValue);
        /// <summary> ApacheSkyWalking. </summary>
        public static BuildpackBindingType ApacheSkyWalking { get; } = new BuildpackBindingType(ApacheSkyWalkingValue);
        /// <summary> AppDynamics. </summary>
        public static BuildpackBindingType AppDynamics { get; } = new BuildpackBindingType(AppDynamicsValue);
        /// <summary> Dynatrace. </summary>
        public static BuildpackBindingType Dynatrace { get; } = new BuildpackBindingType(DynatraceValue);
        /// <summary> NewRelic. </summary>
        public static BuildpackBindingType NewRelic { get; } = new BuildpackBindingType(NewRelicValue);
        /// <summary> ElasticAPM. </summary>
        public static BuildpackBindingType ElasticApm { get; } = new BuildpackBindingType(ElasticApmValue);
        /// <summary> Determines if two <see cref="BuildpackBindingType"/> values are the same. </summary>
        public static bool operator ==(BuildpackBindingType left, BuildpackBindingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BuildpackBindingType"/> values are not the same. </summary>
        public static bool operator !=(BuildpackBindingType left, BuildpackBindingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BuildpackBindingType"/>. </summary>
        public static implicit operator BuildpackBindingType(string value) => new BuildpackBindingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BuildpackBindingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BuildpackBindingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
