// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> State of the Buildpack Binding. </summary>
    public readonly partial struct BuildpackBindingProvisioningState : IEquatable<BuildpackBindingProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BuildpackBindingProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BuildpackBindingProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";

        /// <summary> Creating. </summary>
        public static BuildpackBindingProvisioningState Creating { get; } = new BuildpackBindingProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static BuildpackBindingProvisioningState Updating { get; } = new BuildpackBindingProvisioningState(UpdatingValue);
        /// <summary> Succeeded. </summary>
        public static BuildpackBindingProvisioningState Succeeded { get; } = new BuildpackBindingProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static BuildpackBindingProvisioningState Failed { get; } = new BuildpackBindingProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static BuildpackBindingProvisioningState Deleting { get; } = new BuildpackBindingProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="BuildpackBindingProvisioningState"/> values are the same. </summary>
        public static bool operator ==(BuildpackBindingProvisioningState left, BuildpackBindingProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BuildpackBindingProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(BuildpackBindingProvisioningState left, BuildpackBindingProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BuildpackBindingProvisioningState"/>. </summary>
        public static implicit operator BuildpackBindingProvisioningState(string value) => new BuildpackBindingProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BuildpackBindingProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BuildpackBindingProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
