// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Describes an available Azure Spring Apps SKU. </summary>
    public partial class AvailableAppPlatformSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvailableAppPlatformSku"/>. </summary>
        internal AvailableAppPlatformSku()
        {
            Locations = new ChangeTrackingList<AzureLocation>();
            LocationInfo = new ChangeTrackingList<AppPlatformSkuLocationInfo>();
            Restrictions = new ChangeTrackingList<AppPlatformSkuRestrictions>();
        }

        /// <summary> Initializes a new instance of <see cref="AvailableAppPlatformSku"/>. </summary>
        /// <param name="resourceType"> Gets the type of resource the SKU applies to. </param>
        /// <param name="name"> Gets the name of SKU. </param>
        /// <param name="tier"> Gets the tier of SKU. </param>
        /// <param name="capacity"> Gets the capacity of SKU. </param>
        /// <param name="locations"> Gets the set of locations that the SKU is available. </param>
        /// <param name="locationInfo"> Gets a list of locations and availability zones in those locations where the SKU is available. </param>
        /// <param name="restrictions">
        /// Gets the restrictions because of which SKU cannot be used. This is
        /// empty if there are no restrictions.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvailableAppPlatformSku(ResourceType? resourceType, string name, string tier, AppPlatformSkuCapacity capacity, IReadOnlyList<AzureLocation> locations, IReadOnlyList<AppPlatformSkuLocationInfo> locationInfo, IReadOnlyList<AppPlatformSkuRestrictions> restrictions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceType = resourceType;
            Name = name;
            Tier = tier;
            Capacity = capacity;
            Locations = locations;
            LocationInfo = locationInfo;
            Restrictions = restrictions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the type of resource the SKU applies to. </summary>
        public ResourceType? ResourceType { get; }
        /// <summary> Gets the name of SKU. </summary>
        public string Name { get; }
        /// <summary> Gets the tier of SKU. </summary>
        public string Tier { get; }
        /// <summary> Gets the capacity of SKU. </summary>
        public AppPlatformSkuCapacity Capacity { get; }
        /// <summary> Gets the set of locations that the SKU is available. </summary>
        public IReadOnlyList<AzureLocation> Locations { get; }
        /// <summary> Gets a list of locations and availability zones in those locations where the SKU is available. </summary>
        public IReadOnlyList<AppPlatformSkuLocationInfo> LocationInfo { get; }
        /// <summary>
        /// Gets the restrictions because of which SKU cannot be used. This is
        /// empty if there are no restrictions.
        /// </summary>
        public IReadOnlyList<AppPlatformSkuRestrictions> Restrictions { get; }
    }
}
