// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Additional App settings in vnet injection instance. </summary>
    public partial class AppVnetAddons
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppVnetAddons"/>. </summary>
        public AppVnetAddons()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppVnetAddons"/>. </summary>
        /// <param name="isPublicEndpoint"> Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet. </param>
        /// <param name="publicEndpointUri"> URL of the App in vnet injection instance which could be accessed from internet. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppVnetAddons(bool? isPublicEndpoint, Uri publicEndpointUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsPublicEndpoint = isPublicEndpoint;
            PublicEndpointUri = publicEndpointUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet. </summary>
        public bool? IsPublicEndpoint { get; set; }
        /// <summary> URL of the App in vnet injection instance which could be accessed from internet. </summary>
        public Uri PublicEndpointUri { get; }
    }
}
