// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Supported deployment runtime version descriptor. </summary>
    public partial class AppPlatformSupportedRuntimeVersion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformSupportedRuntimeVersion"/>. </summary>
        internal AppPlatformSupportedRuntimeVersion()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformSupportedRuntimeVersion"/>. </summary>
        /// <param name="value"> The raw value which could be passed to deployment CRUD operations. </param>
        /// <param name="platform"> The platform of this runtime version (possible values: "Java" or ".NET"). </param>
        /// <param name="version"> The detailed version (major.minor) of the platform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformSupportedRuntimeVersion(AppPlatformSupportedRuntimeValue? value, AppPlatformSupportedRuntimePlatform? platform, string version, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            Platform = platform;
            Version = version;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The raw value which could be passed to deployment CRUD operations. </summary>
        public AppPlatformSupportedRuntimeValue? Value { get; }
        /// <summary> The platform of this runtime version (possible values: "Java" or ".NET"). </summary>
        public AppPlatformSupportedRuntimePlatform? Platform { get; }
        /// <summary> The detailed version (major.minor) of the platform. </summary>
        public string Version { get; }
    }
}
