// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> The raw value which could be passed to deployment CRUD operations. </summary>
    public readonly partial struct AppPlatformSupportedRuntimeValue : IEquatable<AppPlatformSupportedRuntimeValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformSupportedRuntimeValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformSupportedRuntimeValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Java8Value = "Java_8";
        private const string Java11Value = "Java_11";
        private const string Java17Value = "Java_17";
        private const string NetCore31Value = "NetCore_31";

        /// <summary> Java_8. </summary>
        public static AppPlatformSupportedRuntimeValue Java8 { get; } = new AppPlatformSupportedRuntimeValue(Java8Value);
        /// <summary> Java_11. </summary>
        public static AppPlatformSupportedRuntimeValue Java11 { get; } = new AppPlatformSupportedRuntimeValue(Java11Value);
        /// <summary> Java_17. </summary>
        public static AppPlatformSupportedRuntimeValue Java17 { get; } = new AppPlatformSupportedRuntimeValue(Java17Value);
        /// <summary> NetCore_31. </summary>
        public static AppPlatformSupportedRuntimeValue NetCore31 { get; } = new AppPlatformSupportedRuntimeValue(NetCore31Value);
        /// <summary> Determines if two <see cref="AppPlatformSupportedRuntimeValue"/> values are the same. </summary>
        public static bool operator ==(AppPlatformSupportedRuntimeValue left, AppPlatformSupportedRuntimeValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformSupportedRuntimeValue"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformSupportedRuntimeValue left, AppPlatformSupportedRuntimeValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformSupportedRuntimeValue"/>. </summary>
        public static implicit operator AppPlatformSupportedRuntimeValue(string value) => new AppPlatformSupportedRuntimeValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformSupportedRuntimeValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformSupportedRuntimeValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
