// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> The platform of this runtime version (possible values: "Java" or ".NET"). </summary>
    public readonly partial struct AppPlatformSupportedRuntimePlatform : IEquatable<AppPlatformSupportedRuntimePlatform>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformSupportedRuntimePlatform"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformSupportedRuntimePlatform(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JavaValue = "Java";
        private const string NetCoreValue = ".NET Core";

        /// <summary> Java. </summary>
        public static AppPlatformSupportedRuntimePlatform Java { get; } = new AppPlatformSupportedRuntimePlatform(JavaValue);
        /// <summary> .NET Core. </summary>
        public static AppPlatformSupportedRuntimePlatform NetCore { get; } = new AppPlatformSupportedRuntimePlatform(NetCoreValue);
        /// <summary> Determines if two <see cref="AppPlatformSupportedRuntimePlatform"/> values are the same. </summary>
        public static bool operator ==(AppPlatformSupportedRuntimePlatform left, AppPlatformSupportedRuntimePlatform right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformSupportedRuntimePlatform"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformSupportedRuntimePlatform left, AppPlatformSupportedRuntimePlatform right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformSupportedRuntimePlatform"/>. </summary>
        public static implicit operator AppPlatformSupportedRuntimePlatform(string value) => new AppPlatformSupportedRuntimePlatform(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformSupportedRuntimePlatform other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformSupportedRuntimePlatform other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
