// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Gets or sets the type of the scale. </summary>
    public readonly partial struct AppPlatformSkuScaleType : IEquatable<AppPlatformSkuScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformSkuScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformSkuScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ManualValue = "Manual";
        private const string AutomaticValue = "Automatic";

        /// <summary> None. </summary>
        public static AppPlatformSkuScaleType None { get; } = new AppPlatformSkuScaleType(NoneValue);
        /// <summary> Manual. </summary>
        public static AppPlatformSkuScaleType Manual { get; } = new AppPlatformSkuScaleType(ManualValue);
        /// <summary> Automatic. </summary>
        public static AppPlatformSkuScaleType Automatic { get; } = new AppPlatformSkuScaleType(AutomaticValue);
        /// <summary> Determines if two <see cref="AppPlatformSkuScaleType"/> values are the same. </summary>
        public static bool operator ==(AppPlatformSkuScaleType left, AppPlatformSkuScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformSkuScaleType"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformSkuScaleType left, AppPlatformSkuScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformSkuScaleType"/>. </summary>
        public static implicit operator AppPlatformSkuScaleType(string value) => new AppPlatformSkuScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformSkuScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformSkuScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
