// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> The direction of required traffic. </summary>
    public readonly partial struct AppPlatformServiceTrafficDirection : IEquatable<AppPlatformServiceTrafficDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceTrafficDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformServiceTrafficDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InboundValue = "Inbound";
        private const string OutboundValue = "Outbound";

        /// <summary> Inbound. </summary>
        public static AppPlatformServiceTrafficDirection Inbound { get; } = new AppPlatformServiceTrafficDirection(InboundValue);
        /// <summary> Outbound. </summary>
        public static AppPlatformServiceTrafficDirection Outbound { get; } = new AppPlatformServiceTrafficDirection(OutboundValue);
        /// <summary> Determines if two <see cref="AppPlatformServiceTrafficDirection"/> values are the same. </summary>
        public static bool operator ==(AppPlatformServiceTrafficDirection left, AppPlatformServiceTrafficDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformServiceTrafficDirection"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformServiceTrafficDirection left, AppPlatformServiceTrafficDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformServiceTrafficDirection"/>. </summary>
        public static implicit operator AppPlatformServiceTrafficDirection(string value) => new AppPlatformServiceTrafficDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformServiceTrafficDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformServiceTrafficDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
