// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Test keys payload. </summary>
    public partial class AppPlatformServiceTestKeys
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceTestKeys"/>. </summary>
        internal AppPlatformServiceTestKeys()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceTestKeys"/>. </summary>
        /// <param name="primaryKey"> Primary key. </param>
        /// <param name="secondaryKey"> Secondary key. </param>
        /// <param name="primaryTestEndpoint"> Primary test endpoint. </param>
        /// <param name="secondaryTestEndpoint"> Secondary test endpoint. </param>
        /// <param name="isEnabled"> Indicates whether the test endpoint feature enabled or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformServiceTestKeys(string primaryKey, string secondaryKey, string primaryTestEndpoint, string secondaryTestEndpoint, bool? isEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrimaryKey = primaryKey;
            SecondaryKey = secondaryKey;
            PrimaryTestEndpoint = primaryTestEndpoint;
            SecondaryTestEndpoint = secondaryTestEndpoint;
            IsEnabled = isEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Primary key. </summary>
        public string PrimaryKey { get; }
        /// <summary> Secondary key. </summary>
        public string SecondaryKey { get; }
        /// <summary> Primary test endpoint. </summary>
        public string PrimaryTestEndpoint { get; }
        /// <summary> Secondary test endpoint. </summary>
        public string SecondaryTestEndpoint { get; }
        /// <summary> Indicates whether the test endpoint feature enabled or not. </summary>
        public bool? IsEnabled { get; }
    }
}
