// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Type of the test key. </summary>
    public readonly partial struct AppPlatformServiceTestKeyType : IEquatable<AppPlatformServiceTestKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceTestKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformServiceTestKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "Primary";
        private const string SecondaryValue = "Secondary";

        /// <summary> Primary. </summary>
        public static AppPlatformServiceTestKeyType Primary { get; } = new AppPlatformServiceTestKeyType(PrimaryValue);
        /// <summary> Secondary. </summary>
        public static AppPlatformServiceTestKeyType Secondary { get; } = new AppPlatformServiceTestKeyType(SecondaryValue);
        /// <summary> Determines if two <see cref="AppPlatformServiceTestKeyType"/> values are the same. </summary>
        public static bool operator ==(AppPlatformServiceTestKeyType left, AppPlatformServiceTestKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformServiceTestKeyType"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformServiceTestKeyType left, AppPlatformServiceTestKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformServiceTestKeyType"/>. </summary>
        public static implicit operator AppPlatformServiceTestKeyType(string value) => new AppPlatformServiceTestKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformServiceTestKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformServiceTestKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
